/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.old.ConnectionPointSyncPair;
import com.aptana.ide.syncing.core.old.ISyncEventHandler;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.old.handlers.SyncEventHandlerAdapter;
import com.aptana.ide.syncing.ui.actions.BaseSyncAction;
import com.aptana.ide.syncing.ui.actions.Messages;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.syncing.ui.old.views.SmartSyncDialog;
import com.aptana.ui.util.UIUtils;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import java.util.HashMap;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.MessageBox;

public class SynchronizeFilesAction
extends BaseSyncAction {
    private static String MESSAGE_TITLE = StringUtil.ellipsify((String)Messages.SynchronizeAction_MessageTitle);

    protected void performAction(final IAdaptable[] files, final ISiteConnection site) throws CoreException {
        final IConnectionPoint source = site.getSource();
        final IConnectionPoint dest = site.getDestination();
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    try {
                        IFileStore[] fileStores = SyncUtils.getFileStores(files);
                        ConnectionPointSyncPair cpsp = new ConnectionPointSyncPair(source, dest);
                        SmartSyncDialog dialog = new SmartSyncDialog(SynchronizeFilesAction.this.getShell(), cpsp, fileStores, null);
                        dialog.open();
                        dialog.setHandler((ISyncEventHandler)new SyncEventHandlerAdapter(){

                            public void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
                                IResource resource = (IResource)source.getAdapter(IResource.class);
                                if (resource != null) {
                                    try {
                                        resource.refreshLocal(2, null);
                                    }
                                    catch (CoreException coreException) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    }
                    catch (CoreException e) {
                        MessageBox error = new MessageBox(UIUtils.getActiveShell(), 33);
                        error.setMessage(Messages.SynchronizeFilesAction_ERR_OpeningSyncDialog);
                        error.open();
                        HashMap<String, String> payload = new HashMap<String, String>(2);
                        payload.put("sourceType", site.getSource().getType());
                        SynchronizeFilesAction.this.sendEvent((AnalyticsEvent)new FeatureEvent("remote.sync." + site.getDestination().getType(), payload));
                    }
                }
                finally {
                    HashMap<String, String> payload = new HashMap<String, String>(2);
                    payload.put("sourceType", site.getSource().getType());
                    SynchronizeFilesAction.this.sendEvent((AnalyticsEvent)new FeatureEvent("remote.sync." + site.getDestination().getType(), payload));
                }
            }
        });
    }

    protected String getMessageTitle() {
        return MESSAGE_TITLE;
    }
}

